﻿var userGroups = {
    context: $(".v-userGroups"),
    canModifySettings: $("#ModifyReportingAccess").val() == "True",
    datatable: null,
    refreshDataTable: function () {
        userGroups.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-userGroupsTable").a4datatable({
            advancedFilter: true,
            height: "full",
            stateKey: "ReportingPortalUserGroups",
            ajaxAction: a4.getAction("GetUserGroups", "Reporting", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Key": true },
                { "Name": "Name", "Title": resources.Name, "Data": "Name", "HideInSelector": true },
                { "Name": "Description", "Title": resources.Description, "Data": "Description" }
            ],
            toolBarItems: userGroups.getToolBarItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.map(rows, function (row) { return row.Id });

                switch (action) {
                    case "delete":
                        userGroups.deleteItems(ids);
                        break;
                }
            },
            contextMenuItems: userGroups.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                var id = [row.Id];

                switch (action) {
                    case "properties":
                        modalDialog.showWindow(a4.getAction("EditUserGroup", "Reporting", "Settings", { id: row.Id }), 450, 600, { afterClose: function () { userGroups.refreshDataTable(); } });
                        break;
                    case "delete":
                        userGroups.deleteItems(id);
                        break;
                    case "sendEmail":
                        modalDialog.showConfirmDialog(confirmSendEmailResources, function () {
                            a4.callServerMethod(a4.getAction("SendEmailInvitationToGroup", "Reporting", "Settings"), { groupId: row.Id }, function (result) {
                                userGroups.refreshDataTable();
                            });
                        }, 220, 500, false, {});
                        break;
                    case "editUsers":
                        modalDialog.showWindow(a4.getAction("UserSelector", "Reporting", "Settings", { groupId: row.Id }), 660, 800);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchPortalUserGroups }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-addUserGroup", function () {
            modalDialog.showWindow(a4.getAction("EditUserGroup", "Reporting", "Settings"), 450, 600, { afterClose: function () { userGroups.refreshDataTable(); } });
        });
    },
    deleteItems: function (items) {
        modalDialog.showConfirmDelete(confirmDeleteUserGroupsResources, function () {
            a4.callServerMethod(a4.getAction("DeleteUserGroups", "Reporting", "Settings"), { ids: items },
                function (result) {
                    userGroups.refreshDataTable();
                });
        }, items.length);
    },
    getContextMenuItems: function () {
        var items = [];
        if (this.canModifySettings) {
            items = [
                { "Action": "editUsers", "Label": resources.EditUsers },
                { "Action": "sendEmail", "Label": resources.SendEmail },
                { "Divider": true },
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "properties", "Label": resources.Properties },
            ]
        }
        return items;
    },
    getToolBarItems: function () {
        var items = [];
        if (this.canModifySettings) {
            items = [
               { "Action": "delete", "Label": resources.Delete }
            ]
        }
        return items;
    }
}

$(document).ready(function () {
    if (userGroups.context.length > 0) {
        userGroups.initializeDataTable();
        userGroups.bindEvents();
    }
});